<?php
/**
 * Plugin Name: LOX Backup for WooCommerce
 * Plugin URI: https://backlox.com/integrations/woocommerce
 * Description: Enhanced backup solution for WooCommerce stores with order and product data export
 * Version: 1.0.0
 * Author: LOX Backup
 * Author URI: https://backlox.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: lox-backup-woocommerce
 * Domain Path: /languages
 * Requires at least: 5.6
 * Requires PHP: 7.4
 * WC requires at least: 5.0
 * WC tested up to: 8.4
 *
 * @package LOX_Backup_WooCommerce
 */

if (!defined('ABSPATH')) {
    exit;
}

// Plugin constants
define('LOX_WC_VERSION', '1.0.0');
define('LOX_WC_PLUGIN_FILE', __FILE__);
define('LOX_WC_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('LOX_WC_PLUGIN_URL', plugin_dir_url(__FILE__));

/**
 * Check dependencies
 */
function lox_wc_check_dependencies() {
    $errors = array();

    // Check for LOX Backup base plugin
    if (!class_exists('LOX_Backup_Plugin')) {
        $errors[] = __('LOX Backup plugin is required. Please install and activate LOX Backup first.', 'lox-backup-woocommerce');
    }

    // Check for WooCommerce
    if (!class_exists('WooCommerce')) {
        $errors[] = __('WooCommerce is required. Please install and activate WooCommerce.', 'lox-backup-woocommerce');
    }

    return $errors;
}

/**
 * Display admin notices for missing dependencies
 */
function lox_wc_admin_notices() {
    $errors = lox_wc_check_dependencies();

    if (!empty($errors)) {
        foreach ($errors as $error) {
            echo '<div class="notice notice-error"><p>' . esc_html($error) . '</p></div>';
        }
    }
}
add_action('admin_notices', 'lox_wc_admin_notices');

/**
 * Initialize plugin
 */
function lox_wc_init() {
    $errors = lox_wc_check_dependencies();

    if (!empty($errors)) {
        return;
    }

    // Load classes
    require_once LOX_WC_PLUGIN_DIR . 'includes/class-lox-wc-export.php';
    require_once LOX_WC_PLUGIN_DIR . 'includes/class-lox-wc-backup.php';
    require_once LOX_WC_PLUGIN_DIR . 'includes/class-lox-wc-restore.php';
    require_once LOX_WC_PLUGIN_DIR . 'includes/class-lox-wc-admin.php';

    // Initialize
    LOX_WC_Backup::init();
    LOX_WC_Restore::init();
    LOX_WC_Admin::init();
}
add_action('plugins_loaded', 'lox_wc_init', 20);

/**
 * Declare HPOS compatibility
 */
add_action('before_woocommerce_init', function() {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
});

/**
 * Add settings link to plugins page
 */
function lox_wc_plugin_action_links($links) {
    $settings_link = '<a href="' . admin_url('admin.php?page=lox-backup') . '">' . __('Settings', 'lox-backup-woocommerce') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'lox_wc_plugin_action_links');
