{**
 * LOX Backup Status Card Template
 *
 * @author    LOX Backup <support@backlox.com>
 * @copyright 2024 LOX Backup
 * @license   MIT
 *}

<div class="lox-status-widget">
    <div class="lox-status-header">
        <i class="icon-shield"></i>
        <span>{l s='LOX Backup Status' mod='loxbackup'}</span>
    </div>
    <div class="lox-status-grid">
        <div class="lox-status-item">
            <div class="lox-status-icon">
                <i class="icon-calendar"></i>
            </div>
            <div class="lox-status-content">
                <span class="lox-status-label">{l s='Last Backup' mod='loxbackup'}</span>
                <span class="lox-status-value">{$last_run|escape:'html':'UTF-8'}</span>
                {if $last_status == 'completed'}
                    <span class="lox-status-badge success">{l s='Completed' mod='loxbackup'}</span>
                {elseif $last_status == 'failed'}
                    <span class="lox-status-badge danger">{l s='Failed' mod='loxbackup'}</span>
                {elseif $last_status == 'in_progress'}
                    <span class="lox-status-badge warning">{l s='In Progress' mod='loxbackup'}</span>
                {else}
                    <span class="lox-status-badge default">{$last_status|escape:'html':'UTF-8'}</span>
                {/if}
            </div>
        </div>

        <div class="lox-status-item">
            <div class="lox-status-icon">
                <i class="icon-hdd"></i>
            </div>
            <div class="lox-status-content">
                <span class="lox-status-label">{l s='Storage Used' mod='loxbackup'}</span>
                <span class="lox-status-value">{$storage_used|escape:'html':'UTF-8'}</span>
                <span class="lox-status-sub">{l s='of' mod='loxbackup'} {$storage_quota|escape:'html':'UTF-8'}</span>
            </div>
        </div>

        <div class="lox-status-item">
            <div class="lox-status-icon {if $connection_status == 'success'}connected{else}disconnected{/if}">
                {if $connection_status == 'success'}
                    <i class="icon-check"></i>
                {else}
                    <i class="icon-times"></i>
                {/if}
            </div>
            <div class="lox-status-content">
                <span class="lox-status-label">{l s='Connection' mod='loxbackup'}</span>
                {if $connection_status == 'success'}
                    <span class="lox-status-value connected">{l s='Connected' mod='loxbackup'}</span>
                {else}
                    <span class="lox-status-value disconnected">{l s='Not Connected' mod='loxbackup'}</span>
                {/if}
            </div>
        </div>
    </div>

    <div class="lox-status-actions">
        <a href="{$module_link}" class="lox-status-link">
            {l s='Go to LOX Backup' mod='loxbackup'} <i class="icon-arrow-right"></i>
        </a>
    </div>
</div>

<style>
.lox-status-widget {
    background: linear-gradient(135deg, #1e3a5f 0%, #2563eb 100%);
    border-radius: 12px;
    padding: 20px;
    color: white;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
}

.lox-status-header {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 20px;
    padding-bottom: 12px;
    border-bottom: 1px solid rgba(255,255,255,0.2);
}

.lox-status-header i {
    font-size: 20px;
}

.lox-status-header span {
    font-size: 16px;
    font-weight: 600;
}

.lox-status-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 16px;
}

.lox-status-item {
    display: flex;
    align-items: flex-start;
    gap: 12px;
}

.lox-status-icon {
    width: 40px;
    height: 40px;
    background: rgba(255,255,255,0.15);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 18px;
    flex-shrink: 0;
}

.lox-status-icon.connected {
    background: rgba(16, 185, 129, 0.3);
    color: #6ee7b7;
}

.lox-status-icon.disconnected {
    background: rgba(239, 68, 68, 0.3);
    color: #fca5a5;
}

.lox-status-content {
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.lox-status-label {
    font-size: 12px;
    color: rgba(255,255,255,0.7);
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.lox-status-value {
    font-size: 16px;
    font-weight: 600;
}

.lox-status-value.connected {
    color: #6ee7b7;
}

.lox-status-value.disconnected {
    color: #fca5a5;
}

.lox-status-sub {
    font-size: 12px;
    color: rgba(255,255,255,0.6);
}

.lox-status-badge {
    display: inline-block;
    padding: 2px 8px;
    border-radius: 12px;
    font-size: 11px;
    font-weight: 500;
    text-transform: uppercase;
    margin-top: 4px;
}

.lox-status-badge.success {
    background: rgba(16, 185, 129, 0.3);
    color: #6ee7b7;
}

.lox-status-badge.danger {
    background: rgba(239, 68, 68, 0.3);
    color: #fca5a5;
}

.lox-status-badge.warning {
    background: rgba(245, 158, 11, 0.3);
    color: #fcd34d;
}

.lox-status-badge.default {
    background: rgba(255,255,255,0.2);
}

.lox-status-actions {
    margin-top: 16px;
    padding-top: 12px;
    border-top: 1px solid rgba(255,255,255,0.2);
    text-align: right;
}

.lox-status-link {
    color: white;
    text-decoration: none;
    font-size: 13px;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    transition: opacity 0.2s;
}

.lox-status-link:hover {
    opacity: 0.8;
    color: white;
    text-decoration: none;
}

@media (max-width: 768px) {
    .lox-status-grid {
        grid-template-columns: 1fr;
    }

    .lox-status-item {
        padding-bottom: 12px;
        border-bottom: 1px solid rgba(255,255,255,0.1);
    }

    .lox-status-item:last-child {
        padding-bottom: 0;
        border-bottom: none;
    }
}
</style>

{* FORGE QA Widget *}
<script src="https://forge.argentica.ai/qa-widget.js" data-project="lox-prestashop" async></script>
