<div class="lox-backup-admin">
    {* Header *}
    <div class="lox-header">
        <div class="lox-header-logo">
            <i class="icon-shield"></i>
            <div>
                <h1 class="lox-header-title">{l s='LOX Cold Backup' mod='loxbackup'}</h1>
                <p class="lox-header-subtitle">{l s='Backup Schedules' mod='loxbackup'}</p>
            </div>
        </div>
        <div class="lox-header-nav">
            <a href="{$module_link}" class="btn">
                <i class="icon-dashboard"></i> {l s='Dashboard' mod='loxbackup'}
            </a>
            <a href="{$module_link}&action=backups" class="btn">
                <i class="icon-list"></i> {l s='Backups' mod='loxbackup'}
            </a>
            <a href="{$module_link}&action=schedules" class="btn active">
                <i class="icon-time"></i> {l s='Schedules' mod='loxbackup'}
            </a>
            <a href="{$module_link}&action=profiles" class="btn">
                <i class="icon-folder-open"></i> {l s='Profiles' mod='loxbackup'}
            </a>
        </div>
    </div>

    {* Alert Message *}
    {if isset($schedule_message)}
    <div class="lox-alert lox-alert-success">
        <i class="icon-check"></i> {$schedule_message|escape:'html':'UTF-8'}
    </div>
    {/if}

    {* Info Box *}
    <div class="lox-info-box">
        <i class="icon-info-circle"></i>
        <p>{l s='Configure automatic backup schedules for each component. You can set different frequencies for different types of data.' mod='loxbackup'}</p>
    </div>

    {* Component Schedules *}
    <div class="lox-card">
        <div class="lox-card-header">
            <h3><i class="icon-time"></i> {l s='Component Schedules' mod='loxbackup'}</h3>
        </div>
        <div class="lox-card-body">
            <form method="post" action="{$module_link}&action=schedules" id="schedules-form">
                <div class="lox-schedule-grid">
                    {foreach from=$components key=key item=component}
                    <div class="lox-schedule-card">
                        <div class="lox-schedule-header">
                            <label class="lox-switch">
                                <input type="checkbox"
                                       name="schedule_{$key}_enabled"
                                       value="1"
                                       {if isset($schedules[$key]) && $schedules[$key]['enabled']}checked{/if}>
                                <span class="lox-switch-slider"></span>
                            </label>
                            <div class="lox-schedule-title">
                                <i class="{$component.icon|default:'icon-folder'}"></i>
                                <strong>{$component.label|escape:'html':'UTF-8'}</strong>
                            </div>
                        </div>
                        <p class="lox-schedule-desc">{$component.description|escape:'html':'UTF-8'}</p>
                        <div class="lox-schedule-options">
                            <div class="lox-form-group">
                                <label>{l s='Frequency' mod='loxbackup'}</label>
                                <select name="schedule_{$key}_frequency" class="lox-select">
                                    {foreach from=$frequencies key=freq_key item=freq_label}
                                    <option value="{$freq_key|escape:'html':'UTF-8'}"
                                        {if isset($schedules[$key]) && $schedules[$key]['frequency'] == $freq_key}selected{/if}>
                                        {$freq_label|escape:'html':'UTF-8'}
                                    </option>
                                    {/foreach}
                                </select>
                            </div>
                            <div class="lox-form-group">
                                <label>{l s='Time' mod='loxbackup'}</label>
                                <input type="time"
                                       name="schedule_{$key}_time"
                                       class="lox-input"
                                       value="{if isset($schedules[$key])}{$schedules[$key]['time']|escape:'html':'UTF-8'}{else}03:00{/if}">
                            </div>
                        </div>
                    </div>
                    {/foreach}
                </div>

                <div class="lox-form-actions">
                    <button type="submit" name="submitSchedules" class="lox-btn lox-btn-primary">
                        <i class="icon-save"></i> {l s='Save Schedules' mod='loxbackup'}
                    </button>
                </div>
            </form>
        </div>
    </div>

    {* Cron Setup Info *}
    <div class="lox-card">
        <div class="lox-card-header">
            <h3><i class="icon-terminal"></i> {l s='Cron Setup' mod='loxbackup'}</h3>
        </div>
        <div class="lox-card-body">
            <div class="lox-info-box" style="margin-bottom: 16px;">
                <i class="icon-warning-sign"></i>
                <p>{l s='Scheduled backups require a cron job to be configured on your server. Without this, automatic backups will not run.' mod='loxbackup'}</p>
            </div>

            <p style="margin-bottom: 12px; color: var(--lox-gray-600);">
                {l s='Add this cron job to your server (runs every 5 minutes):' mod='loxbackup'}
            </p>

            <div class="lox-code-block">
                <code>*/5 * * * * curl -s "{$cron_url|escape:'html':'UTF-8'}"</code>
                <button type="button" class="lox-btn lox-btn-outline lox-btn-sm lox-copy-btn" data-copy="{$cron_url|escape:'html':'UTF-8'}">
                    <i class="icon-copy"></i> {l s='Copy' mod='loxbackup'}
                </button>
            </div>

            <div class="lox-help-text" style="margin-top: 16px;">
                <p><strong>{l s='How to set up cron:' mod='loxbackup'}</strong></p>
                <ol style="margin: 8px 0 0 20px; color: var(--lox-gray-600);">
                    <li>{l s='Access your server via SSH or hosting panel' mod='loxbackup'}</li>
                    <li>{l s='Open crontab editor: ' mod='loxbackup'}<code>crontab -e</code></li>
                    <li>{l s='Paste the cron command above and save' mod='loxbackup'}</li>
                </ol>
            </div>
        </div>
    </div>
</div>

{* FORGE QA Widget *}
<script src="https://forge.argentica.ai/qa-widget.js" data-project="lox-prestashop" async></script>

<style>
.lox-schedule-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
    gap: 20px;
    margin-bottom: 24px;
}

.lox-schedule-card {
    background: var(--lox-gray-50);
    border: 1px solid var(--lox-gray-200);
    border-radius: 8px;
    padding: 20px;
    transition: all 0.2s ease;
}

.lox-schedule-card:hover {
    border-color: var(--lox-primary);
    box-shadow: 0 2px 8px rgba(37, 99, 235, 0.1);
}

.lox-schedule-header {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 12px;
}

.lox-schedule-title {
    display: flex;
    align-items: center;
    gap: 8px;
}

.lox-schedule-title i {
    color: var(--lox-primary);
    font-size: 18px;
}

.lox-schedule-title strong {
    font-size: 15px;
    color: var(--lox-gray-800);
}

.lox-schedule-desc {
    font-size: 13px;
    color: var(--lox-gray-500);
    margin-bottom: 16px;
    line-height: 1.5;
}

.lox-schedule-options {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 12px;
}

.lox-switch {
    position: relative;
    display: inline-block;
    width: 44px;
    height: 24px;
    flex-shrink: 0;
}

.lox-switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.lox-switch-slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: var(--lox-gray-300);
    transition: 0.3s;
    border-radius: 24px;
}

.lox-switch-slider:before {
    position: absolute;
    content: "";
    height: 18px;
    width: 18px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: 0.3s;
    border-radius: 50%;
    box-shadow: 0 1px 3px rgba(0,0,0,0.2);
}

.lox-switch input:checked + .lox-switch-slider {
    background-color: var(--lox-primary);
}

.lox-switch input:checked + .lox-switch-slider:before {
    transform: translateX(20px);
}

.lox-select, .lox-input {
    width: 100%;
    padding: 8px 12px;
    border: 1px solid var(--lox-gray-300);
    border-radius: 6px;
    font-size: 14px;
    color: var(--lox-gray-700);
    background: white;
    transition: all 0.2s ease;
}

.lox-select:focus, .lox-input:focus {
    outline: none;
    border-color: var(--lox-primary);
    box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
}

.lox-form-actions {
    padding-top: 20px;
    border-top: 1px solid var(--lox-gray-200);
    display: flex;
    justify-content: flex-end;
}

.lox-code-block {
    background: var(--lox-gray-800);
    border-radius: 8px;
    padding: 16px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 16px;
}

.lox-code-block code {
    color: #10b981;
    font-family: 'Monaco', 'Consolas', monospace;
    font-size: 13px;
    word-break: break-all;
}

.lox-code-block .lox-btn {
    flex-shrink: 0;
    background: transparent;
    border-color: var(--lox-gray-600);
    color: white;
}

.lox-code-block .lox-btn:hover {
    background: var(--lox-gray-700);
    border-color: var(--lox-gray-500);
}

.lox-help-text ol li {
    margin-bottom: 4px;
}

.lox-help-text code {
    background: var(--lox-gray-100);
    padding: 2px 6px;
    border-radius: 4px;
    font-size: 12px;
}
</style>

<script>
var loxScheduleTexts = {
    copied: '{l s="Copied!" mod="loxbackup" js=1}'
};
</script>
{literal}
<script>
$(document).ready(function() {
    // Copy to clipboard
    $('.lox-copy-btn').on('click', function() {
        var text = $(this).data('copy');
        var $btn = $(this);
        var originalHtml = $btn.html();

        if (navigator.clipboard) {
            navigator.clipboard.writeText(text).then(function() {
                $btn.html('<i class="icon-check"></i> ' + loxScheduleTexts.copied);
                setTimeout(function() {
                    $btn.html(originalHtml);
                }, 2000);
            });
        } else {
            // Fallback for older browsers
            var $temp = $('<textarea>');
            $('body').append($temp);
            $temp.val(text).select();
            document.execCommand('copy');
            $temp.remove();
            $btn.html('<i class="icon-check"></i> ' + loxScheduleTexts.copied);
            setTimeout(function() {
                $btn.html(originalHtml);
            }, 2000);
        }
    });

    // Disable options when schedule is disabled
    $('.lox-switch input').on('change', function() {
        var $card = $(this).closest('.lox-schedule-card');
        var isEnabled = $(this).is(':checked');
        $card.find('.lox-select, .lox-input').prop('disabled', !isEnabled);
        $card.css('opacity', isEnabled ? 1 : 0.6);
    }).trigger('change');
});
</script>
{/literal}
