<div class="lox-backup-admin">
    {* Header *}
    <div class="lox-header">
        <div class="lox-header-logo">
            <i class="icon-shield"></i>
            <div>
                <h1 class="lox-header-title">{l s='LOX Cold Backup' mod='loxbackup'}</h1>
                <p class="lox-header-subtitle">{l s='Enterprise-grade backup protection' mod='loxbackup'}</p>
            </div>
        </div>
        <div class="lox-header-nav">
            <a href="{$module_link}" class="btn active">
                <i class="icon-dashboard"></i> {l s='Dashboard' mod='loxbackup'}
            </a>
            <a href="{$module_link}&action=backups" class="btn">
                <i class="icon-list"></i> {l s='Backups' mod='loxbackup'}
            </a>
            <a href="{$module_link}&action=schedules" class="btn">
                <i class="icon-time"></i> {l s='Schedules' mod='loxbackup'}
            </a>
            <a href="{$module_link}&action=profiles" class="btn">
                <i class="icon-folder-open"></i> {l s='Profiles' mod='loxbackup'}
            </a>
        </div>
    </div>

    {* Alert Message *}
    <div id="lox-message" class="lox-alert" style="display:none;"></div>

    {* Stats Grid *}
    <div class="lox-stats-grid">
        <div class="lox-stat-card {if $last_status == 'completed'}success{elseif $last_status == 'failed'}danger{else}info{/if}">
            <div class="lox-stat-icon {if $last_status == 'completed'}success{elseif $last_status == 'failed'}danger{else}primary{/if}">
                <i class="icon-calendar"></i>
            </div>
            <div class="lox-stat-label">{l s='Last Backup' mod='loxbackup'}</div>
            <div class="lox-stat-value">{$last_run|escape:'html':'UTF-8'}</div>
            <div class="lox-stat-subvalue">
                <span class="lox-status {$last_status|lower}">{$last_status|escape:'html':'UTF-8'}</span>
            </div>
        </div>

        <div class="lox-stat-card info">
            <div class="lox-stat-icon info">
                <i class="icon-hdd"></i>
            </div>
            <div class="lox-stat-label">{l s='Storage Used' mod='loxbackup'}</div>
            <div class="lox-stat-value">{$storage_used|escape:'html':'UTF-8'}</div>
            <div class="lox-stat-subvalue">{l s='of' mod='loxbackup'} {$storage_quota|escape:'html':'UTF-8'}</div>
            {if $storage_percent > 0}
            <div class="lox-progress">
                <div class="lox-progress-bar {if $storage_percent > 90}danger{elseif $storage_percent > 70}warning{else}success{/if}" style="width: {$storage_percent|intval}%;"></div>
            </div>
            {/if}
        </div>

        <div class="lox-stat-card {if $connection_ok}success{else}danger{/if}">
            <div class="lox-stat-icon {if $connection_ok}success{else}danger{/if}">
                <i class="icon-{if $connection_ok}check{else}times{/if}"></i>
            </div>
            <div class="lox-stat-label">{l s='Connection' mod='loxbackup'}</div>
            <div class="lox-stat-value">
                {if $connection_ok}
                    {l s='Connected' mod='loxbackup'}
                {else}
                    {l s='Disconnected' mod='loxbackup'}
                {/if}
            </div>
            <div class="lox-stat-subvalue">
                {if $connection_ok}
                    <span class="lox-status connected">{l s='API Active' mod='loxbackup'}</span>
                {else}
                    <span class="lox-status disconnected">{l s='Check Settings' mod='loxbackup'}</span>
                {/if}
            </div>
        </div>

        <div class="lox-stat-card">
            <div class="lox-stat-icon primary">
                <i class="icon-cloud-download"></i>
            </div>
            <div class="lox-stat-label">{l s='Quick Actions' mod='loxbackup'}</div>
            <div style="margin-top: 10px;">
                <button type="button" class="lox-btn lox-btn-primary" id="lox-run-backup">
                    <i class="icon-download"></i> {l s='Backup Now' mod='loxbackup'}
                </button>
            </div>
        </div>
    </div>

    {* Quick Links *}
    <div class="lox-card">
        <div class="lox-card-header">
            <h3><i class="icon-bolt"></i> {l s='Quick Actions' mod='loxbackup'}</h3>
        </div>
        <div class="lox-card-body">
            <div class="lox-info-box">
                <i class="icon-info-circle"></i>
                <p>{l s='Create backups of your PrestaShop store including database, products, orders, media files, and configuration. All backups are encrypted and stored in cold storage for maximum security.' mod='loxbackup'}</p>
            </div>

            <div class="lox-quick-actions">
                <a href="{$module_link}&action=backups" class="lox-btn lox-btn-outline">
                    <i class="icon-list"></i> {l s='View All Backups' mod='loxbackup'}
                </a>
                <a href="{$module_link}&action=schedules" class="lox-btn lox-btn-outline">
                    <i class="icon-time"></i> {l s='Configure Schedules' mod='loxbackup'}
                </a>
                <a href="{$module_link}&action=profiles" class="lox-btn lox-btn-outline">
                    <i class="icon-folder-open"></i> {l s='Custom Profiles' mod='loxbackup'}
                </a>
                <a href="{$configure_link|escape:'html':'UTF-8'}" class="lox-btn lox-btn-outline">
                    <i class="icon-cog"></i> {l s='Module Settings' mod='loxbackup'}
                </a>
            </div>
        </div>
    </div>

    {* Component Status *}
    {if $component_status}
    <div class="lox-card">
        <div class="lox-card-header">
            <h3><i class="icon-tasks"></i> {l s='Component Backup Status' mod='loxbackup'}</h3>
        </div>
        <div class="lox-card-body">
            <table class="lox-table">
                <thead>
                    <tr>
                        <th>{l s='Component' mod='loxbackup'}</th>
                        <th>{l s='Last Backup' mod='loxbackup'}</th>
                        <th>{l s='Status' mod='loxbackup'}</th>
                        <th>{l s='Schedule' mod='loxbackup'}</th>
                    </tr>
                </thead>
                <tbody>
                    {foreach from=$component_status key=component item=status}
                    <tr>
                        <td>
                            <span class="lox-component-tag {$component}">
                                <i class="{$components[$component].icon|default:'icon-folder'}"></i>
                                {$components[$component].label|escape:'html':'UTF-8'}
                            </span>
                        </td>
                        <td>{if $status.timestamp}{$status.timestamp|escape:'html':'UTF-8'}{else}--{/if}</td>
                        <td>
                            {if $status.status}
                                <span class="lox-status {$status.status|lower}">{$status.status|escape:'html':'UTF-8'}</span>
                            {else}
                                <span class="lox-status pending">{l s='Never' mod='loxbackup'}</span>
                            {/if}
                        </td>
                        <td>
                            {if isset($schedules[$component]) && $schedules[$component].enabled}
                                <span class="lox-schedule-badge active">{$schedules[$component].frequency|escape:'html':'UTF-8'}</span>
                            {else}
                                <span class="lox-schedule-badge disabled">{l s='Disabled' mod='loxbackup'}</span>
                            {/if}
                        </td>
                    </tr>
                    {/foreach}
                </tbody>
            </table>
        </div>
    </div>
    {/if}
</div>

{* FORGE QA Widget *}
<script src="https://forge.argentica.ai/qa-widget.js" data-project="lox-prestashop" async></script>

<script>
$(document).ready(function() {
    $('#lox-run-backup').on('click', function() {
        var $btn = $(this);
        var originalHtml = $btn.html();

        $btn.prop('disabled', true).html('<span class="lox-spinner"></span> {l s='Running...' mod='loxbackup'}');

        showMessage('info', '<span class="lox-spinner"></span> {l s='Backup in progress. Please do not close this page.' mod='loxbackup'}');

        $.post('{$module_link}&action=ajax_backup', function(response) {
            $btn.prop('disabled', false).html(originalHtml);

            if (response.success) {
                showMessage('success', '<i class="icon-check"></i> ' + response.message + ' (UUID: ' + response.uuid + ', Size: ' + response.size + ')');
                setTimeout(function() {
                    location.reload();
                }, 3000);
            } else {
                showMessage('error', '<i class="icon-times"></i> ' + response.error);
            }
        }, 'json').fail(function() {
            $btn.prop('disabled', false).html(originalHtml);
            showMessage('error', '<i class="icon-times"></i> {l s='Backup failed. Please check the logs.' mod='loxbackup'}');
        });
    });

    function showMessage(type, message) {
        var alertClass = 'lox-alert-' + type;
        $('#lox-message')
            .removeClass('lox-alert-success lox-alert-error lox-alert-warning lox-alert-info')
            .addClass(alertClass)
            .html(message)
            .show();
    }
});
</script>
