<?php

namespace Drupal\lox_backup;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of LOX Backup Schedules.
 */
class LoxBackupScheduleListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Name');
    $header['component'] = $this->t('Component');
    $header['interval'] = $this->t('Interval');
    $header['status'] = $this->t('Status');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\lox_backup\Entity\LoxBackupSchedule $entity */
    $row['label'] = $entity->label();

    $components = [
      'full' => $this->t('Full Backup'),
      'database' => $this->t('Database'),
      'files' => $this->t('Public Files'),
      'private' => $this->t('Private Files'),
      'config' => $this->t('Configuration'),
    ];
    $row['component'] = $components[$entity->getComponent()] ?? $entity->getComponent();

    $row['interval'] = $entity->getIntervalString();

    $row['status'] = $entity->status() ? $this->t('Enabled') : $this->t('Disabled');

    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function getDefaultOperations(EntityInterface $entity) {
    $operations = parent::getDefaultOperations($entity);

    // Add run now operation.
    $operations['run'] = [
      'title' => $this->t('Run Now'),
      'url' => $entity->toUrl('run-form'),
      'weight' => 50,
    ];

    return $operations;
  }

}
